import java.io.*;
import java.util.*;
import java.math.*;

public class M implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	class Edge implements Comparable<Edge> {
		int u, v, value;

		public Edge(int u, int v, int value) {
			this.u = u;
			this.v = v;
			this.value = value;
		}

		public int compareTo(Edge other) {
			return Integer.compare(value, other.value);
		}
	}

	private void solve() throws IOException {
		int n = nextInt();
		List<Edge> edges = new ArrayList<>();
		int[][] minCut = new int[n][n];
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				int value = nextInt();
				minCut[i][j] = value;
				if (i != j)
					edges.add(new Edge(i, j, value));
			}
		}
		Collections.sort(edges);
		int[] cmpIds = new int[n];
		int[][] result = new int[n][n], currentMinCut = new int[n][n];
		final int inf = Integer.MAX_VALUE / 4;
		for (int i = 0; i < n; i++) {
			cmpIds[i] = i;
			currentMinCut[i][i] = inf;
		}
		boolean ok = true;
		for (Edge e : edges) {
			if (e.value > currentMinCut[e.u][e.v]) {
				int remain = e.value - currentMinCut[e.u][e.v];
				if (cmpIds[e.u] == cmpIds[e.v]) {
					ok = false;
					break;
				}
				//out.println(e.u + " " + e.v + " " + remain);
				result[e.u][e.v] = currentMinCut[e.u][e.v] = remain;
				int firstId = cmpIds[e.u], secondId = cmpIds[e.v];
				for (int a = 0; a < n; a++) {
					for (int b = 0; b < n; b++) {
						if (cmpIds[a] == firstId && cmpIds[b] == secondId) {
							currentMinCut[a][b] = currentMinCut[b][a] = Math
									.min(remain, Math.min(
											currentMinCut[a][e.u],
											currentMinCut[e.v][b]));
						}
					}
				}
				for (int a = 0; a < n; a++) {
					for (int b = 0; b < n; b++) {
						if (cmpIds[a] == firstId)
							cmpIds[a] = secondId;
					}
				}
			}
		}
		if (ok) {
			out.println("YES");
			int count = 0;
			for (int i = 0; i < n; i++)
				for (int j = 0; j < n; j++)
					if (result[i][j] > 0)
						++count;
			out.println(count);
			for (int i = 0; i < n; i++)
				for (int j = 0; j < n; j++)
					if (result[i][j] > 0)
						out.println((i + 1) + " " + (j + 1) + " "
								+ result[i][j]);
		} else {
			out.println("NO");
		}
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new M().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
